<?php
declare(strict_types=1);

session_start();
require_once __DIR__ . '/functions.php';

$key = RC_SECURE_KEY;

$rc = [];
foreach (['paymenttypeid','transid','userid','usertype','transactiontype','invoiceids','debitnoteids','description',
          'sellingcurrencyamount','accountingcurrencyamount','redirecturl','checksum',
          'sellingcurrency','accountingcurrency','currency'] as $k) {
    $rc[$k] = rc_param($k, '') ?? '';
}

$transId  = $rc['transid'];
$checksum = $rc['checksum'];
$redirect = $rc['redirecturl'];

if ($transId === '' || $checksum === '' || $redirect === '' || $rc['sellingcurrencyamount'] === '' || $rc['accountingcurrencyamount'] === '') {
    http_response_code(400);
    echo "Missing required parameters from ResellerClub.";
    exit;
}

if ($key === 'REPLACE_WITH_RESELLERCLUB_SECURE_KEY' || $key === '') {
    http_response_code(500);
    echo "Server not configured: RC_SECURE_KEY missing.";
    exit;
}
if (CINETPAY_SITE_ID === 'REPLACE_WITH_SITE_ID' || CINETPAY_API_KEY === 'REPLACE_WITH_API_KEY') {
    http_response_code(500);
    echo "Server not configured: CINETPAY credentials missing.";
    exit;
}

if (!verifyChecksumFlexible($rc, $key, $checksum)) {
    rc_log("RC_CHECKSUM_MISMATCH", ['transid' => $transId, 'received' => $checksum, 'params' => $rc]);
    http_response_code(403);
    echo "ERROR: Checksum mismatch.";
    exit;
}

// Amount: XAF rounding rule
try {
    $amountXaf = cinetpay_amount_xaf($rc['sellingcurrencyamount']);
} catch (Throwable $e) {
    rc_log("AMOUNT_INVALID", ['transid' => $transId, 'raw' => $rc['sellingcurrencyamount'], 'err' => $e->getMessage()]);
    http_response_code(400);
    echo "Invalid amount: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
    exit;
}

// Save state (session + file)
$state = [
    'rc' => $rc,
    'transid' => $transId,
    'redirecturl' => $redirect,
    'sellingamount_raw' => $rc['sellingcurrencyamount'],
    'sellingamount_xaf' => (string)$amountXaf,
    'out_currency' => CINETPAY_OUT_CURRENCY,
    'createdAt' => date('c'),
];
$_SESSION['rcpg'] = $state;
rc_save_state($transId, $state);

// notify/return URLs for CinetPay -> this gateway endpoint
$notifyUrl = rc_base_url() . 'postpayment.php?mode=notify&transid=' . rawurlencode($transId);
$returnUrl = rc_base_url() . 'postpayment.php?mode=return&transid=' . rawurlencode($transId);

$desc = ($rc['description'] !== '' ? $rc['description'] : "Payment {$transId}");

$customer = [
    'customer_id' => $rc['userid'],
    'customer_name' => rc_param('customer_name', ''),
    'customer_surname' => rc_param('customer_surname', ''),
    'customer_phone_number' => rc_param('customer_phone_number', ''),
    'customer_email' => rc_param('customer_email', ''),
    'customer_country' => rc_param('customer_country', 'CM'),
    'customer_city' => rc_param('customer_city', ''),
    'customer_address' => rc_param('customer_address', ''),
];

$metadata = "rc_transid={$transId}|userid={$rc['userid']}|usertype={$rc['usertype']}|tt={$rc['transactiontype']}|in_currency=" . ($rc['sellingcurrency'] ?: ($rc['currency'] ?: ''));

try {
    $payUrl = cinetpay_init($transId, $amountXaf, $desc, $notifyUrl, $returnUrl, $customer, $metadata);
    header('Location: ' . $payUrl, true, 302);
    exit;
} catch (Throwable $e) {
    rc_log("CINETPAY_INIT_FAIL", ['transid' => $transId, 'err' => $e->getMessage()]);
    http_response_code(502);
    echo "CinetPay init failed: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
    exit;
}
