<?php
declare(strict_types=1);

session_start();
require_once __DIR__ . '/functions.php';

$key = RC_SECURE_KEY;

function respond_ok(string $body = 'OK'): void {
    http_response_code(200);
    header('Content-Type: text/plain; charset=utf-8');
    echo $body;
    exit;
}

function auto_post(string $url, array $fields): void {
    http_response_code(200);
    header('Content-Type: text/html; charset=utf-8');
    echo "<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>";
    echo "<title>Redirecting...</title></head><body>";
    echo "<p style='font-family:Arial,sans-serif'>Redirection en cours...</p>";
    echo "<form id='f' method='post' action='" . htmlspecialchars($url, ENT_QUOTES, 'UTF-8') . "'>";
    foreach ($fields as $k => $v) {
        echo "<input type='hidden' name='" . htmlspecialchars((string)$k, ENT_QUOTES, 'UTF-8') . "' value='" . htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8') . "'>";
    }
    echo "</form><script>document.getElementById('f').submit();</script></body></html>";
    exit;
}

$mode = strtolower(rc_param('mode', 'return') ?? 'return');

// ---- NOTIFY ----
if ($mode === 'notify') {
    $transId = rc_param('transid', null) ?? rc_param('cpm_trans_id', null) ?? rc_param('transaction_id', null);
    if (!$transId) respond_ok('OK'); // GET ping has no data

    try {
        $check = cinetpay_check((string)$transId);
        $state = rc_load_state((string)$transId) ?? [];
        $state['cinetpay_notify_check'] = $check;
        $state['cinetpay_notify_at'] = date('c');
        rc_save_state((string)$transId, $state);
    } catch (Throwable $e) {
        rc_log("CINETPAY_NOTIFY_CHECK_FAIL", ['transid' => $transId, 'err' => $e->getMessage()]);
    }
    respond_ok('OK');
}

// ---- RETURN ----
$transId = rc_param('transid', null) ?? rc_param('cpm_trans_id', null) ?? ($_SESSION['rcpg']['transid'] ?? null);
if (!$transId) respond_ok('OK');

$state = $_SESSION['rcpg'] ?? null;
if (!is_array($state) || (($state['transid'] ?? '') !== $transId)) $state = rc_load_state((string)$transId);
if (!is_array($state)) {
    rc_log("STATE_NOT_FOUND", ['transid' => $transId]);
    http_response_code(400);
    echo "Transaction state not found for transid=" . htmlspecialchars((string)$transId, ENT_QUOTES, 'UTF-8');
    exit;
}

try {
    $check = cinetpay_check((string)$transId);
} catch (Throwable $e) {
    rc_log("CINETPAY_CHECK_FAIL", ['transid' => $transId, 'err' => $e->getMessage()]);
    http_response_code(502);
    echo "CinetPay check failed: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
    exit;
}

$cStatus  = $check['data']['status'] ?? null;
$cMessage = $check['message'] ?? null;
$rcStatus = cinetpay_to_rc_status(is_string($cStatus) ? $cStatus : null, is_string($cMessage) ? $cMessage : null);
$rkey = (string)($check['data']['operator_id'] ?? $check['data']['transaction_id'] ?? $transId);

$rc = $state['rc'] ?? [];
$sellingAmount    = (string)($rc['sellingcurrencyamount'] ?? '');
$accountingAmount = (string)($rc['accountingcurrencyamount'] ?? '');
$redirectUrl      = (string)($rc['redirecturl'] ?? '');

if ($sellingAmount === '' || $accountingAmount === '' || $redirectUrl === '') {
    rc_log("RC_RETURN_MISSING", ['transid' => $transId, 'state' => $state]);
    http_response_code(500);
    echo "Missing ResellerClub redirect parameters.";
    exit;
}

$checksum = generateChecksum((string)$transId, $sellingAmount, $accountingAmount, $rcStatus, $rkey, $key);

$fields = [
    'transid'          => (string)$transId,
    'status'           => $rcStatus, // Y / N / P
    'rkey'             => $rkey,
    'checksum'         => $checksum,
    'sellingamount'    => $sellingAmount,
    'accountingamount' => $accountingAmount,
];

rc_log("RC_RETURN_POST", ['transid' => $transId, 'status' => $rcStatus, 'redirecturl' => $redirectUrl]);

auto_post($redirectUrl, $fields);
