# Supersite2 (ResellerClub) x NotchPay module (paymentpage.php / postpayment.php)

## 1) Clés à renseigner
Ouvre `functions.php` et remplace :
- `RC_SECURE_KEY` : Secure Key fourni par ResellerClub / Supersite2
- `NOTCHPAY_API_KEY` : API key NotchPay (utilisée dans le header `Authorization`) 
- (optionnel) `NOTCHPAY_WEBHOOK_HASH` : hash key pour vérifier les webhooks (HMAC SHA-256) 

## 2) Dossier storage
Le dossier `storage/` doit être **inscriptible** par PHP (chmod 775 / propriétaire www-data).
Il sert à garder la transaction (redirecturl, montants…) même si la session se perd.

## 3) Callback et Webhook
- Callback (redirect user) : `postpayment.php?mode=callback`
  - NotchPay redirige avec `?reference=...` 
  - On vérifie via `GET /payments/{reference}` 
- Webhook (optionnel) : `postpayment.php?mode=webhook`
  - Signature: header `x-notch-signature` + hash (HMAC SHA-256) 

## 4) Devise
Supersite2 ne passe pas toujours la devise dans les paramètres de la page de paiement.
Par défaut on utilise `NOTCHPAY_DEFAULT_CURRENCY = XAF`.  
Si tu veux forcer une autre devise, tu peux ajouter `&currency=USD` (ou autre) dans l’URL d’appel à `paymentpage.php`.

## 5) Customer (email/phone)
NotchPay a besoin d’au moins un identifiant client (email/phone/customer).   
Si Supersite2 ne transmet pas email/phone, `paymentpage.php` affiche un mini-formulaire pour collecter ces infos puis lance le paiement.
